/*
 * Decompiled with CFR 0.152.
 */
package org.sablecc.sablecc;

import java.util.LinkedList;
import java.util.Map;
import org.sablecc.sablecc.Cast;
import org.sablecc.sablecc.NodeCast;
import org.sablecc.sablecc.StringCast;
import org.sablecc.sablecc.TypedHashMap;
import org.sablecc.sablecc.analysis.DepthFirstAdapter;
import org.sablecc.sablecc.node.AAlt;
import org.sablecc.sablecc.node.AAltTransform;
import org.sablecc.sablecc.node.AElem;
import org.sablecc.sablecc.node.AProd;
import org.sablecc.sablecc.node.ASimpleListTerm;
import org.sablecc.sablecc.node.ASimpleTerm;
import org.sablecc.sablecc.node.PTerm;
import org.sablecc.sablecc.node.TId;

public class In_Production {
    private String name;
    private String[] prodTransformElems;
    private int nbAlts;
    private In_Alternative[] alternatives;

    public In_Production(AProd aProd) {
        this.setName(aProd.getId().getText());
        AElem[] aElemArray = aProd.getProdTransform().toArray(new AElem[0]);
        this.prodTransformElems = new String[aElemArray.length];
        for (int i = 0; i < aElemArray.length; ++i) {
            this.prodTransformElems[i] = aElemArray[i].getElemName() != null ? aElemArray[i].getElemName().getText() : aElemArray[i].getId().getText();
        }
        if (aElemArray.length == 0) {
            this.prodTransformElems = new String[1];
            this.prodTransformElems[0] = new String("  ");
        }
        AAlt[] aAltArray = aProd.getAlts().toArray(new AAlt[0]);
        this.alternatives = new In_Alternative[aAltArray.length];
        for (int i = 0; i < aAltArray.length; ++i) {
            this.addAlternative(i, new In_Alternative(aAltArray[i], this.prodTransformElems, this.name));
        }
        this.nbAlts = aAltArray.length;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public int getNbAlts() {
        return this.nbAlts;
    }

    public void addAlternative(int n, In_Alternative in_Alternative) {
        this.alternatives[n] = in_Alternative;
    }

    public In_Alternative getAlternative(int n) {
        return this.alternatives[n];
    }

    class In_Alternative {
        String name;
        int nbElems;
        AElem[] elements;
        Map prodTransform_altTransform;

        In_Alternative(AAlt aAlt, String[] stringArray, String string) {
            this.setName(aAlt.getAltName() != null ? aAlt.getAltName().getText() : "");
            this.elements = new AElem[aAlt.getElems().size()];
            AElem[] aElemArray = aAlt.getElems().toArray(new AElem[0]);
            final String string2 = this.name.equals("") ? string : string + "#" + this.name;
            for (int i = 0; i < aElemArray.length; ++i) {
                AElem aElem = (AElem)aElemArray[i].clone();
                if (aElem.getElemName() != null) {
                    aElem.setElemName(new TId(string2 + "#" + aElem.getElemName().getText()));
                } else {
                    aElem.setElemName(new TId(string2 + "#" + aElem.getId().getText()));
                }
                this.addElem(i, aElem);
            }
            this.nbElems = aElemArray.length;
            this.prodTransform_altTransform = new TypedHashMap(stringArray.length, (Cast)StringCast.instance, (Cast)NodeCast.instance);
            LinkedList linkedList = ((AAltTransform)aAlt.getAltTransform()).getTerms();
            for (int i = 0; i < linkedList.size(); ++i) {
                PTerm pTerm = (PTerm)linkedList.get(i);
                pTerm.apply(new DepthFirstAdapter(){

                    public void caseASimpleListTerm(ASimpleListTerm aSimpleListTerm) {
                        aSimpleListTerm.setId(new TId(string2 + "#" + aSimpleListTerm.getId().getText(), aSimpleListTerm.getId().getLine(), aSimpleListTerm.getId().getPos()));
                    }

                    public void caseASimpleTerm(ASimpleTerm aSimpleTerm) {
                        aSimpleTerm.setId(new TId(string2 + "#" + aSimpleTerm.getId().getText(), aSimpleTerm.getId().getLine(), aSimpleTerm.getId().getPos()));
                    }
                });
                this.prodTransform_altTransform.put(stringArray[i], pTerm);
            }
        }

        void setName(String string) {
            this.name = string;
        }

        String getName() {
            return this.name;
        }

        int getNbElems() {
            return this.nbElems;
        }

        Map getProdTransform_AlTransformMap() {
            return this.prodTransform_altTransform;
        }

        void addElem(int n, AElem aElem) {
            this.elements[n] = aElem;
        }

        AElem[] getElems() {
            return this.elements;
        }
    }
}

