# encoding: utf-8
=begin

* Name: SiSU

** Description: documents, structuring, processing, publishing, search
*** html segment generation, processing

** Author: Ralph Amissah
  <ralph@amissah.com>
  <ralph.amissah@gmail.com>

** Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
  2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015 Ralph Amissah,
  All Rights Reserved.

** License: GPL 3 or later:

  SiSU, a framework for document structuring, publishing and search

  Copyright (C) Ralph Amissah

  This program is free software: you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation, either version 3 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along with
  this program. If not, see <http://www.gnu.org/licenses/>.

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
  <http://www.fsf.org/licensing/licenses/gpl.html>
  <http://www.gnu.org/licenses/gpl.html>

  <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

** SiSU uses:
  * Standard SiSU markup syntax,
  * Standard SiSU meta-markup syntax, and the
  * Standard SiSU object citation numbering and system

** Hompages:
  <http://www.jus.uio.no/sisu>
  <http://www.sisudoc.org>

** Git
  <http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
  <http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=blob;f=lib/sisu/html_segments.rb;hb=HEAD>

=end
module SiSU_HTML_Seg
  require_relative 'html_shared'                        # html_shared.rb
  require_relative 'html'                               # html.rb
  require_relative 'html_persist'                       # html_persist.rb
  require_relative 'html_promo'                         # html_promo.rb
  require_relative 'shared_metadata'                    # shared_metadata.rb
  class Output
    def initialize(md,outputfile,per,minitoc,type='')
      @md, @output_seg_file,@per,@minitoc,@type=
        md,outputfile,      per,minitoc,  type
      @title_banner_=SiSU_Env::CreateSite.new(@md.opt).html_seg_title_banner?
      @file=SiSU_Env::FileOp.new(@md)
      @make=SiSU_Env::ProcessingSettings.new(@md)
      @cl=(@make.build.html_minitoc?) \
      ? 'content'
      : 'content0'
    end
    def output
      if @per.title =~/\S/
        filename_seg=[]
        if @make.build.html_top_band?
          filename_seg \
          << @per.title \
          << @per.tocband_banner
        else
          filename_seg \
          << @per.title
        end
        if @type=='endnotes'
          @per.headings=[]
          format_head_seg=SiSU_HTML_Format::HeadSeg.new(@md)
          if @title_banner_
            @per.headings \
            << format_head_seg.
              title_banner(@md.title.main,@md.title.sub,@author)
          end
          txt_obj={ txt: 'Endnotes', ocn_display: '' }
          format_seg=SiSU_HTML_Format::FormatSeg.new(@md,txt_obj)
          @per.headings \
          << format_seg.title_heading1
          filename_seg \
          << @per.heading_endnotes \
          << @minitoc << @per.headings \
          << %{\n<div class="#{@cl}">\n} \
          << @per.endnote_all \
          << '</div>' # << '</div>'
        elsif @type=='idx'
          @per.headings=[]
          format_head_seg=SiSU_HTML_Format::HeadSeg.new(@md)
          if @title_banner_
            @per.headings \
            << format_head_seg.
              title_banner(@md.title.main,@md.title.sub,@author)
          end
          txt_obj={ txt: 'Index', ocn_display: '' }
          format_seg=SiSU_HTML_Format::FormatSeg.new(@md,txt_obj)
          @per.headings << format_seg.title_heading1
          filename_seg \
          << @per.heading_idx \
          << @minitoc << @per.headings \
          << %{\n<div class="#{@cl}">\n} \
          << @per.idx \
          << '</div>' # << '</div>'
        elsif @type=='metadata'
          metadata=SiSU_Metadata::Summary.new(@md).html_display.metadata
          @per.headings=[]
          format_head_seg=SiSU_HTML_Format::HeadSeg.new(@md)
          if @title_banner_
            @per.headings \
            << format_head_seg.
              title_banner(@md.title.main,@md.title.sub,@author)
          end
          txt_obj={ txt: 'Metadata', ocn_display: '' }
          format_seg=SiSU_HTML_Format::FormatSeg.new(@md,txt_obj)
          @per.headings \
          << format_seg.title_heading1
          filename_seg \
          << @per.heading_idx \
          << @minitoc \
          << @per.headings \
          << %{\n<div class="#{@cl}">\n} \
          << metadata \
          << '</div>' # << '</div>'
        else
          if @make.build.html_top_band?
            filename_seg \
            << @minitoc \
            << @per.headings \
            << @per.main \
            << "\n</div>\n"
          else
            filename_seg \
            << @minitoc \
            << @per.main \
            << "\n</div>\n"
          end
        end
        filename_seg <<=if @make.build.html_top_band?
          @per.tail \
          << @per.tocband_bannerless \
          << @per.credits
        else
          @per.tail \
          << @per.credits
        end
        filename_seg=filename_seg.flatten.compact #watch
        filename_seg.each do |str|
          unless str =~/\A\s*\Z/
            str=str.strip.
              gsub(Xx[:html_relative2],
                @file.path_rel_links.html_seg_2).
              gsub(Xx[:html_relative1],
                @file.path_rel_links.html_seg_1)
            @output_seg_file << str
          end
        end
        @output_seg_file.close
      end
    end
  end
  class Seg
    @@seg_url=''
    @@tracker=0
    @@seg_name=[]
    attr_reader :seg_name_x,:seg_name_x_tracker
    def initialize(md=nil,data='')
      @md,@data=md,data
      @per=SiSU_HTML_Persist::Persist.new
      @seg_name_x=@per.seg_name_x=(@@seg_name || [])
      @seg_name_x_tracker=@per.seg_name_x_tracker=(@@tracker || 0)
      @env=SiSU_Env::InfoEnv.new(@md.fns) if @md
      if @md
        @make=SiSU_Env::ProcessingSettings.new(@md)
        @cl=(@make.build.html_minitoc?) \
        ? 'content'
        : 'content0'
      else @cl='content'
      end
      if @md
        @title_banner_=SiSU_Env::CreateSite.new(@md.opt).html_seg_title_banner?
      end
    end
    def songsheet
      begin
        @minitoc=SiSU_HTML::Source::Toc.new(@md,@data).minitoc
        @per=SiSU_HTML_Persist::Persist.new
        data=get_subtoc_endnotes(@data,@per)
        data=articles(data,@per)
        cleanup(@md,@per) # (((( added ))))
        #### (((( END )))) ####
      rescue
        SiSU_Errors::Rescued.new($!,$@,@md.opt.selections.str,@md.fns).location do
          __LINE__.to_s + ':' + __FILE__
        end
      ensure
        SiSU_HTML_Persist::Persist.new.persist_init
        @@seg_name=@per.seg_name=[]
      end
    end
  protected
    def articles(data,per)
      @per=per
      tracking,newfile=0,0
      printed_endnote_seg='n'
      idx_html=nil
      if @md.book_idx
        #my_make_source_file=SiSU_Env::CreateFile.new(@md.fns)
        idx_html=SiSU_Particulars::CombinedSingleton.
          instance.get_idx_html(@md.opt).html_idx
        idx_html.each do |x|
          @per.idx << x
        end
        @per.heading_idx=''
      end
      data.each do |dob|
        if (dob.is == :heading \
        || dob.is == :heading_insert) \
        && dob.ln == 4
          @@seg_name << dob.name
          @per.seg_name = @@seg_name
          dob.name
        end
      end
      @per.seg_name_x=@per.seg_name
      @per.seg_name.length
      testforartnum=@per.seg_name_x
      if (@md.opt.act[:verbose][:set]==:on \
      || @md.opt.act[:verbose_plus][:set]==:on \
      || @md.opt.act[:maintenance][:set]==:on)
        SiSU_Screen::Ansi.new(
          @md.opt.act[:color_state][:set],
          @per.seg_name.length
        ).segmented
      end
      map_nametags=SiSU_Particulars::CombinedSingleton.
        instance.get_map_nametags(@md).nametags_map #p map_nametags
      data.each do |dob|
        if defined? dob.obj \
        and dob.obj =~/href="#{Xx[:segment]}#+\S+?"/
          while dob.obj =~/href="#{Xx[:segment]}#+(\S+?)"/
            m=$1
            if map_nametags[m] \
            and map_nametags[m][:segname]
              inf=SiSU_Env::FileOp.new(@md) if @md
              lng=(inf.output_dir_structure.by_language_code?) \
              ? ''
              : '.' + @md.opt.lng
              dob.obj.sub!(/href="#{Xx[:segment]}#+(\S+?)"/,
                %{href="#{map_nametags[m][:segname]}#{lng}#{Sfx[:html]}#\\1"})
            else
              p "NOT FOUND name_tags: #{m}"
              dob.obj.sub!(/href="#{Xx[:segment]}#+(\S+?)"/,
                %{href="#\\1"}) # not satisfactory
            end
          end
        end
        if (dob.is==:heading \
        || dob.is==:heading_insert) \
        && dob.ln==4
          @per.heading4=dob.obj
          @per.is4=newfile=1
        end
        if (dob.is==:heading \
        || dob.is==:heading_insert) \
        && dob.ln==3
          @per.heading3=dob.obj
          @per.is4,@per.is3=0,1
        end
        if (dob.is==:heading \
        || dob.is==:heading_insert) \
        && dob.ln==2
          @per.heading2=dob.obj
          @per.is4,@per.is3,@per.is2=0,0,1
        end
        if (dob.is==:heading \
        || dob.is==:heading_insert) \
        && dob.ln==1
          @per.heading1=dob.obj
          @per.is4,@per.is3,@per.is2,@per.is1=0,0,0,1
        end
        if (dob.is==:heading \
        || dob.is==:heading_insert) \
        && dob.ln==0
          @per.heading0=dob.obj
          @per.is4,@per.is3,@per.is2,@per.is1,@per.is0=0,0,0,0,1
        end
        if (@per.is1 && !@per.is2 && !@per.is3 && !@per.is4)
          if not (dob.is==:heading \
          || dob.is==:heading_insert) \
          && dob.ln==0
            $_ #; check
          end
        end
        if @per.is4==1
          if newfile==1 \
          or dob.obj =~/^#{Mx[:br_endnotes]}|^#{Mx[:br_eof]}/
            newfile=0
            if (dob.is==:heading \
            || dob.is==:heading_insert) \
            && dob.ln==4
              if tracking != 0
                @file=SiSU_Env::FileOp.new(@md)
                unless FileTest.directory?(@file.output_path.html_seg.dir)
                  FileUtils::mkdir_p(@file.output_path.html_seg.dir) \
                    if File.writable?("#{@file.output_path.base.dir}/.")
                end
                tail(@md,@per)
                #SiSU_HTML_Seg::Seg.new(@md,@per).tail
                fnh={
                  fn: @per.seg_name_x[tracking-1],
                }
                fn=@md.file.base_filename.html_seg(fnh)
                segfilename="#{@file.output_path.html_seg.dir}/#{fn}"
                output_seg_file=File.new(segfilename,'w') if @per.seg_name_x[tracking-1]
                minitoc=(@make.build.html_minitoc?) ? @minitoc : ''
                if dob.is==:heading \
                || (@per.seg_name_x[tracking-1] !~/endnotes|book_index|metadata/)
                  SiSU_HTML_Seg::Output.new(@md,output_seg_file,@per,minitoc).output
                elsif dob.is==:heading_insert
                  if @per.seg_name_x[tracking-1]=='endnotes'
                    SiSU_HTML_Seg::Output.new(@md,output_seg_file,@per,minitoc,'endnotes').output
                  elsif @per.seg_name_x[tracking-1]=='book_index'
                    SiSU_HTML_Seg::Output.new(@md,output_seg_file,@per,minitoc,'idx').output
                    @per.idx=[]
                  elsif @per.seg_name_x[tracking-1]=='metadata'
                    SiSU_HTML_Seg::Output.new(@md,output_seg_file,@per,minitoc,'metadata').output
                  else puts "#{__FILE__}::#{__LINE__}"
                  end
                else puts "#{__FILE__}::#{__LINE__}"
                end
                SiSU_HTML_Seg::Seg.new.reinitialise(per)
                #per=persist_init
                heading_art(dob)
                head(dob)
               #keep use for last segment, eg if metadata is last segment
                if @per.seg_name_x[tracking] =='metadata' # this is for metadata
                  fnh={
                    fn: @per.seg_name_x[tracking],
                  }
                  fn=@md.file.base_filename.html_seg(fnh)
                  segfilename="#{@file.output_path.html_seg.dir}/#{fn}"
                  output_seg_file=File.new(segfilename,'w')
                  SiSU_HTML_Seg::Output.new(@md,output_seg_file,@per,minitoc,'metadata').output
                  #per=persist_init
                  Seg.new.reinitialise(per)
                end
              end
              if tracking==0
                heading_art(dob)
                head(dob)
              end
            end
            tracking=tracking+1
          end
          if (dob.is==:heading \
          || dob.is==:heading_insert) \
          && dob.ln==4 \
          && dob.name
            @per.get_hash_to=dob.name
            @per.get_hash_fn=dob.name
          end
          if dob.obj.is_a?(String)
            markup(dob)
          elsif dob.obj.is_a?(Array)
            dob.obj.each do |pg|
              markup(pg)
            end
          end
          if testforartnum[tracking-1] =~/endnote/
            if printed_endnote_seg=='n'
              printed_endnote_seg='y'
            end
          end
        end
      end
      data
    end
    def heading_art(dob)
      format_head_seg=SiSU_HTML_Format::HeadSeg.new(@md)
      @per.dot_nav=if (@make.build.html_navigation?) \
      && (@make.build.html_navigation_bar?)
        x=if (dob.is==:heading \
        || dob.is==:heading_insert) \
        && (dob.ln.to_s =~/^[0-7]/)
          x=if @@tracker < @per.seg_name.length-1
            format_head_seg.dot_control_pre_next
          else
            format_head_seg.dot_control_pre
          end
        else @per.dot_nav
        end
      else @per.dot_nav=''
      end
      ads=SiSU_HTML_Promo::Ad.new(@md)
      @per.title=format_head_seg.head_seg << ads.div.major
    end
    def head(dob)
      clean=/<!.*?!>|<:.*?>/
      format_head_seg=SiSU_HTML_Format::HeadSeg.new(@md)
      if @make.build.html_navigation?
        if @@tracker < @per.seg_name.length-1
          @per.segtocband=if @@tracker==0
            format_head_seg.toc_next2
          else
            format_head_seg.toc_pre_next2
          end
        else @per.segtocband=format_head_seg.toc_pre2
        end
      else @per.segtocband=''
      end
      @p_num ||= ''
      if @per.is0==1
        @author=%{<b>#{@md.author}</b>\n} if @md.author.to_s =~/\S/
        @per.tocband_banner \
        << format_head_seg.navigation_band(@per.segtocband,@per.dot_nav)
        @per.tocband_bannerless \
        << '<br>' \
        << format_head_seg.navigation_band_bottom(@per.segtocband,@per.dot_nav)
        if @title_banner_
          @per.headings \
          << format_head_seg.title_banner(@md.title.main,@md.title.sub,@author).gsub(clean,'')
        end
        ocn=(@per.heading0[/.+?#{Mx[:id_o]}~(\d+);(?:[oh]|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#{@dp}:#{@dp}#{Mx[:id_c]}$/]) \
        ? $1
        : ''
        @p_num=SiSU_HTML_Format::ParagraphNumber.new(@md,ocn)
        txt_obj={ txt: @per.heading0, ocn_display: @p_num.ocn_display }
        format_seg=SiSU_HTML_Format::FormatSeg.new(@md,txt_obj)
        @per.headings \
        << format_seg.title_heading0.gsub(clean,'')
        @per.heading0=@per.heading0.
          gsub(/&nbsp;<a name="-[\d*+]+" href="#_[\d*+]+">&nbsp;<sup>[\d*+]+<\/sup>&nbsp;<\/a>/,'')
      end
      if @per.is1==1
        heading1=@per.heading1
        ocn=(heading1[/.+?#{Mx[:id_o]}~(\d+);(?:[oh]|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#{@dp}:#{@dp}#{Mx[:id_c]}$/]) \
        ? $1
        : ''
        @p_num=SiSU_HTML_Format::ParagraphNumber.new(@md,ocn)
        txt_obj={ txt: heading1, ocn_display: @p_num.ocn_display }
        format_seg=SiSU_HTML_Format::FormatSeg.new(@md,txt_obj)
        @per.headings \
        << format_seg.title_heading1.gsub(clean,'')
        @per.heading1=@per.heading1.
          gsub(/&nbsp;<a name="-[\d*+]+" href="#_[\d*+]+">&nbsp;<sup>[\d*+]+<\/sup>&nbsp;<\/a>/,'')
      end
      if @per.is2==1
        heading2=@per.heading2
        ocn=(heading2[/.+?#{Mx[:id_o]}~(\d+);(?:[oh]|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#{@dp}:#{@dp}#{Mx[:id_c]}$/]) \
        ? $1
        : ''
        @p_num=SiSU_HTML_Format::ParagraphNumber.new(@md,ocn)
        txt_obj={ txt: heading2, ocn_display: @p_num.ocn_display }
        format_seg=SiSU_HTML_Format::FormatSeg.new(@md,txt_obj)
        @per.headings \
        << format_seg.title_heading2.gsub(clean,'')
        @per.heading2=@per.heading2.
          gsub(/&nbsp;<a name="-[\d*+]+" href="#_[\d*+]+">&nbsp;<sup>[\d*+]+<\/sup>&nbsp;<\/a>/,'')
      end
      if @per.is3==1
        heading3=@per.heading3
        ocn=(heading3[/.+?#{Mx[:id_o]}~(\d+);(?:[oh]|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#{@dp}:#{@dp}#{Mx[:id_c]}$/]) \
        ? $1
        : ''
        @p_num=SiSU_HTML_Format::ParagraphNumber.new(@md,ocn)
        txt_obj={ txt: heading3, ocn_display: @p_num.ocn_display }
        format_seg=SiSU_HTML_Format::FormatSeg.new(@md,txt_obj)
        @per.headings \
        << format_seg.title_heading3.gsub(clean,'')
        @per.heading3=@per.heading3.
          gsub(/&nbsp;<a name="-[\d*+]+" href="#_[\d*+]+">&nbsp;<sup>[\d*+]+<\/sup>&nbsp;<\/a>/,'')
      end
      if @per.is4==1
        heading4=@per.heading4
        ocn=(heading4[/.+?#{Mx[:id_o]}~(\d+);(?:[oh]|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#{@dp}:#{@dp}#{Mx[:id_c]}$/]) \
        ? $1
        : ''
        @p_num=SiSU_HTML_Format::ParagraphNumber.new(@md,ocn)
        txt_obj={ txt: heading4, ocn_display: @p_num.ocn_display }
        format_seg=SiSU_HTML_Format::FormatSeg.new(@md,txt_obj)
        @per.headings \
        << format_seg.title_heading4.gsub(clean,'')
      end
      @@tracker=@@tracker+1
    end
    def markup(dob)
      @debug=[]
      SiSU_HTML_Format::HeadSeg.new(@md)
      if dob.is !=:meta
        if dob.is==:heading \
        || dob.is==:heading_insert \
        || dob.is == :para
          @p_num=SiSU_HTML_Format::ParagraphNumber.new(@md,dob.ocn)
        end
        sto=SiSU_HTML_Format::FormatTextObject.new(@md,dob)
        dob_html=if dob.is == :heading \
        || dob.is==:heading_insert \
        || dob.is==:para
          dob_html=if dob.is==:heading \
          || dob.is==:heading_insert
            if dob.ln==4
              sto.seg_heading4
            elsif dob.ln==5
              sto.seg_heading5
            elsif dob.ln==6
              sto.seg_heading6
            elsif dob.ln==7
              sto.seg_heading6
            end
          elsif dob.is==:para
            if dob.indent \
            and dob.hang \
            and dob.indent =~/[0-9]/ \
            and dob.hang =~/[0-9]/
              if dob.bullet_
                if dob.indent =~/[1-9]/
                  sto.format('li',"i#{dob.indent}")
                else
                  sto.format('li','bullet')
                end
              elsif dob.indent == dob.hang
                sto.format('p',"i#{dob.indent}")
              elsif dob.indent != dob.hang
                sto.format('p',"h#{dob.hang}i#{dob.indent}")
              else sto.para
              end
            else sto.para
            end
          end
        elsif dob.is==:block
          sto.block
        elsif dob.is==:group
          sto.group
        elsif dob.is==:alt
          sto.alt
        elsif dob.is==:verse
          sto.verse
        elsif dob.is==:code
          sto.code
        elsif dob.is==:table
          sto.table
        elsif dob.is==:break \
        and dob.from==:markup
          '<br><hr width=90% /><br>'
        end
        if @md.flag_separate_endnotes
          dob.obj=dob.obj.gsub(/"\s+href="#(#{Mx[:note]}\d+)">/,%{" href=\"endnotes#{Sfx[:html]}#\\1">})       #endnote- twice #removed file type
        end
        if (dob.is==:heading \
        || dob.is==:heading_insert \
        || dob.is==:para) \
        && (not dob.ocn \
        || (dob.ocn.to_s.empty?))
          format_seg=SiSU_HTML_Format::FormatSeg.new(@md,dob)
        end
        dob.obj=dob.obj.gsub(/\s*(-\{{2}~\d+|<:e[:_]\d+>).*/,'')                   #potentially dagerous - removes all paragraphs with <!e_!> #?? workpoint
        if dob.obj =~/<a name="_\d+" href="#-\d+">&nbsp;<sup>/                #endnote- note-
          format_seg=SiSU_HTML_Format::FormatSeg.new(@md,dob)
          dob=format_seg.no_paranum
        end
        if (dob.is==:heading \
        || dob.is==:heading_insert) \
        && dob.ln==4
          @per.main << %{\n<div class="#{@cl}">\n}
          @per.main << dob_html
          if @make.build.segsubtoc?
            @per.main << @per.seg_subtoc[@per.get_hash_fn]                       #% insertion of sub-toc
          end
        else
          @per.main << dob_html #unless @@flag_alt==true
        end
      end
    end
    def tail(md,per)
      @md,@per=md,per
      format_head_seg=SiSU_HTML_Format::HeadSeg.new(@md)
      if @md.flag_auto_endnotes \
      and @per.seg_endnotes[@per.get_hash_fn]
        @per.tail <<  %{\n<div class="#{@cl}">\n<div class="endnote">\n}
        if @per.seg_endnotes[@per.get_hash_fn].flatten.length > 0
          @per.tail << format_head_seg.endnote_mark
          @per.tail << @per.seg_endnotes[@per.get_hash_fn].flatten #endnotes deposited at end of individual segments ||@|EXTRACTION OF ENDNOTES|
        end
        @per.tail << '</div>'
        @per.tail << '</div>' #this div closes div class content
      end
      ads=SiSU_HTML_Promo::Ad.new(@md)
      @per.credits \
      << format_head_seg.credit \
      << ads.div.close \
      << ads.display \
      << format_head_seg.html_close
    end
    def reinitialise(per)
      per.title,per.dot_nav,per.tocband_banner,per.tocband_bannerless,per.headings,per.main,per.tail,per.credits=Array.new(8){[]}
      @per.segtocband=nil
    end
    def cleanup(md,per)
      #per=persist_init
      reinitialise(per)
      @@tracker=0
      @per.seg_endnotes,@per.seg_subtoc={},{}
      @per.seg_endnotes_array,@per.seg_subtoc_array=[],[]
      per.endnote_all=[]
    end
    def get_subtoc_endnotes(data,per) #get endnotes & sub-table of contents subtoc
      @per=per
      data.each do |dob|
        dob.obj=dob.obj.gsub(/<a name=\"h\d.*?\">(.+?)<\/a>/mi,'\1')
        if @md.flag_auto_endnotes
          if (dob.is==:heading \
          || dob.is==:heading_insert) \
          && (dob.ln.to_s =~/^[0-4]/) \
          and not @per.fn.to_s.empty?
            @per.seg_endnotes[@per.fn]=[]
            @per.seg_endnotes[@per.fn] << @per.seg_endnotes_array
            @per.seg_endnotes_array=[] if dob.ln==4
          end
          if (dob.is==:heading \
          || dob.is==:heading_insert) \
          && dob.ln==4                                              #%  EXTRACTION OF SUB-TOCs & SEGMENT NAME, after EXTRACTION OF ENDNOTES & SUB-TOCs
            @per.seg_subtoc[@per.fn]=@per.seg_subtoc_array
            @per.seg_subtoc_array=[]
            if dob.name \
            and dob.obj
              @per.fn=dob.name
            else
              if dob.name =~/\S+/
                @per.fn=dob.name
              else @per.fn=''
              end
            end
          end
        end
        if dob.is==:heading \
        && (dob.ln.to_s =~/^[5-7]/)
          case dob.ln
          when 5
            txt_obj={ txt: dob.obj.strip, ocn: dob.ocn }
            format_seg=SiSU_HTML_Format::FormatSeg.new(@md,txt_obj)
            subtoc=format_seg.subtoc_lev5 #keep and make available, this is the subtoc
          when 6
            txt_obj={ txt: dob.obj.strip, ocn: dob.ocn }
            format_seg=SiSU_HTML_Format::FormatSeg.new(@md,txt_obj)
            subtoc=format_seg.subtoc_lev6 #keep and make available, this is the subtoc
          when 7
            txt_obj={ txt: dob.obj.strip, ocn: dob.ocn }
            format_seg=SiSU_HTML_Format::FormatSeg.new(@md,txt_obj)
            subtoc=format_seg.subtoc_lev7 #keep and make available, this is the subtoc
          end
          @per.seg_subtoc_array << subtoc
        end
        if @md.flag_auto_endnotes
          if (dob.obj =~/(?:#{Mx[:en_a_o]}|#{Mx[:en_b_o]})[\d*+]+\s*<a href="##{Mx[:note_ref]}[\d*+]+"/) \
          && dob.is !=:code # endnote-
            endnote_array=[]
            if dob.obj=~/#{Mx[:en_a_o]}.+?#{Mx[:en_a_c]}/m
              endnote_array << dob.obj.scan(/#{Mx[:en_a_o]}.+?#{Mx[:en_a_c]}/m)
            end
            if dob.obj=~/#{Mx[:en_b_o]}[*]\d+\s.+?#{Mx[:en_b_c]}/m
              endnote_array \
              << dob.obj.scan(/#{Mx[:en_b_o]}[*]\d+\s.+?#{Mx[:en_b_c]}/m)
            end
            if dob.obj=~/#{Mx[:en_b_o]}[+]\d+\s.+?#{Mx[:en_b_c]}/m
              endnote_array \
              << dob.obj.scan(/#{Mx[:en_b_o]}[+]\d+\s.+?#{Mx[:en_b_c]}/m)
            end
            endnote_array=endnote_array.flatten.compact #watch, check compacting
            endnote_array.each do |note|
              note_match=note.dup
              note_match_seg=note.dup
              e_n=note_match_seg[/(?:#{Mx[:en_a_o]}[\d*+]+|#{Mx[:en_b_o]}[*+]\d+)\s+(.+?)(?:#{Mx[:en_a_c]}|#{Mx[:en_b_c]})/m,1]
              try=e_n.split(/<br(?: \/)?>/)
              try.each do |e|
                txt_obj={ txt: e }
                format_seg=SiSU_HTML_Format::FormatSeg.new(@md,txt_obj)
                note_match=if e =~/#{Mx[:pa_o]}i[1-9]#{Mx[:pa_c]}/
                  format_seg.endnote_body_indent
                else format_seg.endnote_body
                end
                @per.seg_endnotes_array << note_match
              end
              try.join('<br>')
              #% creation of separate end segment/page of all endnotes referenced back to reference segment
              m=/(?:#{Mx[:en_a_o]}[\d*+]+|#{Mx[:en_b_o]}[*+]\d+)\s+(.+?href=")(##{Mx[:note_ref]}[\d*+]+".+)(?:#{Mx[:en_a_c]}|#{Mx[:en_b_c]})/mi
              endnote_part_a=note_match_seg[m,1]
              endnote_part_b=note_match_seg[m,2]
              txt_obj={ endnote_part_a: endnote_part_a, endnote_part_b: endnote_part_b }
              format_seg=SiSU_HTML_Format::FormatSeg.new(@md,txt_obj)
              note_match_all_seg=format_seg.endnote_seg_body(@per.fn) #BUG WATCH 200408
              @per.endnote_all << note_match_all_seg
            end
            dob.obj=dob.obj.gsub(/(?:#{Mx[:en_a_o]}.+?#{Mx[:en_a_c]}|#{Mx[:en_b_o]}.+?#{Mx[:en_b_c]})\s*/m,' ')
          end
        end
      end
    end
  end
end
__END__
