#!/usr/bin/perl
#
# Print node Id - node name - X / Y / Z from Cray-XT SDB database.
#
# $Id: get_coords_from_sdb.pl,v 1.3 2011/06/10 10:47:29 grenker Exp grenker $
use strict;
use warnings;
use DBI;

our ($sql, $dbh, $sth);

#-----------------------------------------------------------------------------------
# XTAdmin.processor table
#-----------------------------------------------------------------------------------
# processor_id		int(10)		=> numerical nid, use 'nid%05d'
# cpu			int(11)		=> node id 0..2
# slot			int(11)		=> slot    0..7
# cage			int(11)		=> cage    0..2
# cabinet		int(11)		=> NULL
# cab_position		int(11)		=> cabinet position within row
# cab_row		int(11)		=> row position
# processor_status	enum('up','down','unavail','route','suspect','admindown')
# x_coord		int(11)
# y_coord		int(11)
# z_coord		int(11)
# processor_type	enum('service','compute')
# alloc_mode		enum('interactive','batch','other')
# process_slots		int(11)
# process_slots_free	int(11)
# processor_spec	varchar(80)
# next_red_black_switch	datetime
# od_allocator_id	int(10) unsigned
#-----------------------------------------------------------------------------------
# NB: If node state is not 'up', coordinates may be NULL in the 'processor' table.
#     I have seen this on louhi.
$sql = <<mySQL;
	SELECT	processor_id,
		cab_position, cab_row, cage, slot, cpu,
		x_coord, y_coord, z_coord
	FROM  processor
	WHERE processor_type   = 'compute'
	AND   processor_status = 'up'
mySQL

# SCRIPT PROPER
$dbh = DBI->connect("DBI:mysql:database=XTAdmin;host=sdb", "basic", "basic",
                    { RaiseError => 1 } );

$sth = $dbh->prepare($sql);
$sth->execute() || die "Couldn't execute '$sql': $DBI::errstr\n";

-t 1 && print "   NID   NODENAME    X   Y   Z\n";
while (my $href = $sth->fetchrow_hashref) {
	printf "%6d c%d-%dc%ds%dn%d  %3d %3d %3d\n", 
		$$href{'processor_id'},
		$$href{'cab_position'}, $$href{'cab_row'},
		$$href{'cage'}, $$href{'slot'}, $$href{'cpu'},
		$$href{'x_coord'}, $$href{'y_coord'}, $$href{'z_coord'};
}
$sth->finish();

$dbh->disconnect();
