use ui;
use layout;
use graphics;
use core:geometry;
use core:lang;

dialog CompileErrorDialog {
	layout Grid {
		expandCol: 0;
		expandRow: 1;

		Label message("") { row: 0; col: 0; colspan: 2; }
		CodeView code { row: 1; col: 0; colspan: 2; }
		Label disclaimer("") { row: 2; col: 0; colspan: 2; }
		Button ok("OK") { row: 3; col: 1; }
	}

	init(Str message, SrcPos pos) {
		// Note: It would be nice to be able to initialize things in the layout in the initializer
		// list as well! Then we would not have to change the message of 'message'.
		init("Compilation error", Size(300, 400)) {}

		defaultChoice = ok;

		this.message.text = message;
		var me = this;
		ok.onClick = () => me.close(0);
		code.painter = ErrorPainter(pos);

		Bool useDisclaimer = false;
		if (file = pos.file) {
			if (file.ext == "cpp" | file.ext == "c") {
				useDisclaimer = true;
			}
		}

		if (useDisclaimer) {
			StrBuf msg;
			msg << "Note: This C/C++ implementation is not entirely complete.\n";
			msg << "If this works in a regular C/C++ compiler, it is possible that you\n";
			msg << "are using features that are not implemented, or that you have found a\n";
			msg << "bug in the implementation. Please contact filip.stromback@liu.se\n";
			msg << "if you think this is the case.";
			disclaimer.text = msg.toS;
		}
	}
}

class CodeView extends Window {
	Size minSize() : override {
		Size(200, 200);
	}
}

class ErrorPainter extends Painter {
	init(SrcPos pos) {
		init() {}

		view.textFg = SolidBrush(defaultTextColor);
		view.display(pos);
		view.highlight = SolidBrush(Color(1, 0.0, 0.0, 0.3));
	}

	SourceView view;

	Bool render(Size me, Graphics g) : override {
		view.draw(g, Rect(Point(0, 0), me));
		false;
	}
}
