use test;

value ToSFull {
	Int v;

	init(Int v) {
		init { v = v; }
	}

	void toS(StrBuf to) {
		to << "strbuf:" << v;
	}

	Str toS() {
		"str:" # v;
	}
}

value ToSLimited {
	Int v;

	init(Int v) {
		init { v = v; }
	}

	Str toS() {
		"str:" # v;
	}
}

suite ToSImpl {
	ToSFull full(1);
	ToSLimited limited(2);

	test full.toS() == "str:1";
	test (StrBuf() << full).toS == "strbuf:1";
	test ("!" # full) == "!strbuf:1";
	test "!${full}" == "!strbuf:1";
	test ToSFull:[full].toS == "[strbuf:1]";

	test limited.toS() == "str:2";
	test (StrBuf() << limited).toS == "str:2";
	test ("!" # limited) == "!str:2";
	test "!${limited}" == "!str:2";
	test ToSLimited:[limited].toS == "[str:2]";
}
