/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_EXTERNPROVIDER_H
#define _SC_EXTERNPROVIDER_H

// sc
#include "util/String.h"

// qt
class QWidget;


class ExternProvider
{
public:
  enum ExternProviderFlags {
    File, Dir
  };

  virtual ~ExternProvider() {}

  virtual bool selectUrl( QWidget* parent, const sc::String& src,
    sc::String& result, long flags = Dir ) = 0;
  virtual bool selectPath( QWidget* parent, const sc::String& src,
    sc::String& result, long flags = Dir ) = 0;
};


#endif //  _SC_EXTERNPROVIDER_H
